clear all;
close all;
clc;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% FILTER BANK CONSTRUCTION

% set number of filters
M = 32;

% set filter length;
L = 2*M;

w = zeros(1,L);
h = zeros(M,L);
g = zeros(M,L);

% define the low-pass window
for n = 1:L
   w(1,n) = sin((pi/(2*M))*(n - 1 + 0.5));
end

for k = 1:M	
   %compute analysis and synthesis filters
   for n = 1:L
      h(k,n) = w(n)*sqrt(2/M)*cos(((2*(n - 1) + M + 1) * (2*(k - 1) + 1) * pi)/(4*M));  % analysis filter
      g(k,L - n + 1) = h(k,n);   % synthesis filter
   end
end